/****************************************************************************

   Copyright (c) 2000, Western Avionics LTD.             All Rights Reserved.

*****************************************************************************

   File          : nasadll.c

   Author        : S.J.Buckley

   Date          : 01-March-2000

   Function      : This file is used to generate a DLL for the SBIIB drivers.

   Update        : dd-mm-yy
   By            : S.J.Buckley
   Reason        :

****************************************************************************/

#include "nasadll.h"

/****************************************************************************
                            Main DLL routine
****************************************************************************/
int WINAPI LibMain(
                   HINSTANCE  hInstance,
                   WORD       wDataSeg,
                   WORD       wHeapSize,
                   LPSTR      lpszCmdLine)
/***************************************************************************/
{
    return (1);
}

/****************************************************************************
                            SB_SETUP.C routines
****************************************************************************/

Error WINAPI SBIIB_SetupDLL(CardHandle *card, Uword mode, SetupInfo *info)
{
    return (SBIIB_Setup(card, mode, info));
}

Error WINAPI SBIIB_RdSetupDLL(CardHandle *card, SetupInfo *info)
{
    return (SBIIB_RdSetup(card, info));
}

Error WINAPI SBIIB_SetupLdbBcDLL(CardHandle *card)
{
    return (SBIIB_SetupLdbBc(card));
}

Error WINAPI SBIIB_SetupLdbRtDLL(CardHandle *card)
{
    return (SBIIB_SetupLdbRt(card));
}

Error WINAPI SBIIB_SetupMonDLL(CardHandle *card)
{
    return (SBIIB_SetupMon(card));
}

/****************************************************************************
                            SB_LIBRY.C routines
****************************************************************************/

Error WINAPI SBIIB_RdStatusDLL(CardHandle *card, Uword  *status)
{
    return (SBIIB_RdStatus(card, status));
}

Error WINAPI SBIIB_GetCardIDDLL(CardHandle *card, CardID *info)
{
    return (SBIIB_GetCardID(card, info));
}

Error WINAPI SBIIB_CommandDLL(CardHandle *card, Uword command)
{
    return (SBIIB_Command(card, command));
}

Error WINAPI SBIIB_SetErrDLL(CardHandle *card, Ulong offset, TXerrs *info)
{
    return (SBIIB_SetErr(card, offset, info));
}

Error WINAPI SBIIB_GetErrDLL(CardHandle *card, Ulong offset, TXerrs *info)
{								 
    return (SBIIB_GetErr(card, offset, info));
}

Error WINAPI SBIIB_RdTtagDLL(CardHandle *card, Ulong offset, TimeTag *time)
{
    return (SBIIB_RdTtag(card, offset, time));
}

Error WINAPI SBIIB_LoadClockDLL(CardHandle *card, ClockInit *info)
{
    return (SBIIB_LoadClock(card, info));
}

Error WINAPI SBIIB_FormatTtagDLL(Uword hgh, Uword mid,
                                 Uword low, Uword tck, TimeTag *time)
{
    return (SBIIB_FormatTtag(hgh, mid,low, tck, time));
}

Error WINAPI SBIIB_RdBinQDLL(CardHandle *card, LDB_BIN_Qdata *qData)
{
    return (SBIIB_RdBinQ(card, qData));
}

/****************************************************************************
                            SB_LDBBC.C routines
****************************************************************************/

Error WINAPI SBIIB_WrProgDLL(CardHandle *card, LDB_BCT_PROGinfo *info)
{
    return (SBIIB_WrProg(card, info));
}

Error WINAPI SBIIB_RdProgDLL(CardHandle *card, LDB_BCT_PROGinfo *info)
{
    return (SBIIB_RdProg(card, info));
}

Error WINAPI SBIIB_WrMsgDLL(CardHandle *card, LDB_BCT_MSGinfo  *info)
{
    return (SBIIB_WrMsg(card, info));
}

Error WINAPI SBIIB_RdMsgDLL(CardHandle *card, LDB_BCT_MSGinfo  *info)
{
    return (SBIIB_RdMsg(card, info));
}

Error WINAPI SBIIB_RdLdbBcQDLL(CardHandle *card, LDB_BCT_Qdata *qData)
{
    return (SBIIB_RdLdbBcQ(card, qData));
}

Error WINAPI SBIIB_RunLdbBcDLL(CardHandle *card, Uword count)
{
    return (SBIIB_RunLdbBc(card, count));
}

/****************************************************************************
                            SB_LDBRT.C routines
****************************************************************************/

Error WINAPI SBIIB_WrLdbRTDLL(CardHandle *card, LDB_MRTinfo *info)
{
    return (SBIIB_WrLdbRT(card, info));
}

Error WINAPI SBIIB_RdLdbRTDLL(CardHandle *card, LDB_MRTinfo *info)
{
    return (SBIIB_RdLdbRT(card, info));
}

Error WINAPI SBIIB_RdLdbRTstateDLL(CardHandle *card, Uword *state)
{
    return (SBIIB_RdLdbRTstate(card, state));
}

Error WINAPI SBIIB_WrLdbRTactionDLL(CardHandle *card, Uword action)
{
    return (SBIIB_WrLdbRTaction(card, action));
}

Error WINAPI SBIIB_RdLdbRtQDLL(CardHandle *card, LDB_MRT_Qdata *qData)
{
    return (SBIIB_RdLdbRtQ(card, qData));
}

Error WINAPI SBIIB_RunLdbRtDLL(CardHandle *card, Uword rtNo)
{
    return (SBIIB_RunLdbRt(card, rtNo));
}

/****************************************************************************
                            SB_BSMON.C routines
****************************************************************************/

Error WINAPI SBIIB_WrMonTriggerDLL(CardHandle *card, BUS_MON_TRIGinfo *info)
{
    return (SBIIB_WrMonTrigger(card, info));
}

Error WINAPI SBIIB_RdMonTriggerDLL(CardHandle *card, BUS_MON_TRIGinfo *info)
{
    return (SBIIB_RdMonTrigger(card, info));
}

Error WINAPI SBIIB_RdMonMsgDLL(CardHandle *card,
                               Slong msgNo, BUS_MON_Msg *info)
{
    return (SBIIB_RdMonMsg(card, msgNo, info));
}

Error WINAPI SBIIB_RdMonMsgAbsDLL(CardHandle *card,
                                  Ulong address, BUS_MON_Msg *info)
{
    return(SBIIB_RdMonMsgAbs(card, address, info));
}

Error WINAPI SBIIB_RdMonCarTorDLL(CardHandle *card, Ulong *car, Ulong *tor)
{
    return(SBIIB_RdMonCarTor(card, car, tor));
}

Error WINAPI SBIIB_ClrMonStackDLL(CardHandle *card)
{
    return(SBIIB_ClrMonStack(card));
}

Error WINAPI SBIIB_RunMonDLL(CardHandle *card)
{
    return(SBIIB_RunMon(card));
}

/****************************************************************************
                            SB_IOFNS.C routines
****************************************************************************/

Error WINAPI SBIIB_InitDLL(CardHandle *card, Ulong cardAddress)
{
    return(SBIIB_Init(card, cardAddress));
}

Error WINAPI SBIIB_RdClockDLL(CardHandle *card, TimeTag *time)
{
    return(SBIIB_RdClock(card, time));
}

void WINAPI wWDLL(CardHandle *card, Ulong offset, Uword value)
{
    wW(card, offset, value);
}

Uword WINAPI rWDLL(CardHandle *card, Ulong offset)
{
    return(rW(card, offset));
}
