/****************************************************************************

   Copyright (c) 2000, Western Avionics LTD.             All Rights Reserved.

*****************************************************************************

   File          : nasadll.h

   Author        : S.J.Buckley

   Date          : 01-March-2000

   Function      : This file is used to generate a DLL for the SBIIB drivers.

   Update        : dd-mm-yy
   By            : S.J.Buckley
   Reason        :

****************************************************************************/

#include "sbiib.h"
#include <winbase.h>

/****************************************************************************
                            Main DLL routine
****************************************************************************/
int WINAPI LibMain(
                   HINSTANCE  hInstance,
                   WORD       wDataSeg,
                   WORD       wHeapSize,
                   LPSTR      lpszCmdLine);

/****************************************************************************
                            SB_SETUP.C routines
****************************************************************************/

Error WINAPI SBIIB_SetupDLL(CardHandle *card, Uword mode, SetupInfo *info);
Error WINAPI SBIIB_RdSetupDLL(CardHandle *card, SetupInfo *info);
Error WINAPI SBIIB_SetupLdbBcDLL(CardHandle *card);
Error WINAPI SBIIB_SetupLdbRtDLL(CardHandle *card);
Error WINAPI SBIIB_SetupMonDLL(CardHandle *card);

/****************************************************************************
                            SB_LIBRY.C routines
****************************************************************************/

Error WINAPI SBIIB_RdStatusDLL(CardHandle *card, Uword  *status);
Error WINAPI SBIIB_GetCardIDDLL(CardHandle *card, CardID *info);
Error WINAPI SBIIB_CommandDLL(CardHandle *card, Uword command);
Error WINAPI SBIIB_SetErrDLL(CardHandle *card, Ulong offset, TXerrs *info);
Error WINAPI SBIIB_GetErrDLL(CardHandle *card, Ulong offset, TXerrs *info);
Error WINAPI SBIIB_RdTtagDLL(CardHandle *card, Ulong offset, TimeTag *time);
Error WINAPI SBIIB_LoadClockDLL(CardHandle *card, ClockInit *info);
Error WINAPI SBIIB_FormatTtagDLL(Uword hgh, Uword mid,
                                 Uword low, Uword tck, TimeTag *time);
Error WINAPI SBIIB_RdBinQDLL(CardHandle *card, LDB_BIN_Qdata *qData);

/****************************************************************************
                            SB_LDBBC.C routines
****************************************************************************/

Error WINAPI SBIIB_WrProgDLL(CardHandle *card, LDB_BCT_PROGinfo *info);
Error WINAPI SBIIB_RdProgDLL(CardHandle *card, LDB_BCT_PROGinfo *info);
Error WINAPI SBIIB_WrMsgDLL(CardHandle *card, LDB_BCT_MSGinfo  *info);
Error WINAPI SBIIB_RdMsgDLL(CardHandle *card, LDB_BCT_MSGinfo  *info);
Error WINAPI SBIIB_RdLdbBcQDLL(CardHandle *card, LDB_BCT_Qdata *qData);
Error WINAPI SBIIB_RunLdbBcDLL(CardHandle *card, Uword count);

/****************************************************************************
                            SB_LDBRT.C routines
****************************************************************************/

Error WINAPI SBIIB_WrLdbRTDLL(CardHandle *card, LDB_MRTinfo *info);
Error WINAPI SBIIB_RdLdbRTDLL(CardHandle *card, LDB_MRTinfo *info);
Error WINAPI SBIIB_RdLdbRTstateDLL(CardHandle *card, Uword *state);
Error WINAPI SBIIB_WrLdbRTactionDLL(CardHandle *card, Uword action);
Error WINAPI SBIIB_RdLdbRtQDLL(CardHandle *card, LDB_MRT_Qdata *qData);
Error WINAPI SBIIB_RunLdbRtDLL(CardHandle *card, Uword rtNo);

/****************************************************************************
                            SB_BSMON.C routines
****************************************************************************/

Error WINAPI SBIIB_WrMonTriggerDLL(CardHandle *card, BUS_MON_TRIGinfo *info);
Error WINAPI SBIIB_RdMonTriggerDLL(CardHandle *card, BUS_MON_TRIGinfo *info);
Error WINAPI SBIIB_RdMonMsgDLL(CardHandle *card,
                               Slong msgNo, BUS_MON_Msg *info);
Error WINAPI SBIIB_RdMonMsgAbsDLL(CardHandle *card,
                                  Ulong address, BUS_MON_Msg *info);
Error WINAPI SBIIB_RdMonCarTorDLL(CardHandle *card, Ulong *car, Ulong *tor);
Error WINAPI SBIIB_ClrMonStackDLL(CardHandle *card);
Error WINAPI SBIIB_RunMonDLL(CardHandle *card);

/****************************************************************************
                            SB_IOFNS.C routines
****************************************************************************/

Error WINAPI SBIIB_InitDLL(CardHandle *card, Ulong cardAddress);
Error WINAPI SBIIB_RdClockDLL(CardHandle *card, TimeTag *time);
void  WINAPI wWDLL(CardHandle *card, Ulong offset, Uword value);
Uword WINAPI rWDLL(CardHandle *card, Ulong offset);
