static Uword dArray[0x10000];

/****************************************************************************

   Copyright (c) 2000, Western Avionics LTD.             All Rights Reserved.

*****************************************************************************

   File          : sb_iofns.c

   Author        : S.J.Buckley

   Date          : 11-01-2000

   Function      : SBIIB card access module.

   Update        : dd-mm-yy
   By            : S.J.Buckley
   Reason        :

****************************************************************************/
#include "sbiib.h"

/****************************************************************************

 Function  : SBIIB_Init

 Purpose   : This function initialises the SBIIB card handle.

 Input(s)  : card        - handle for the card
             cardAddress - Address of VME card (Not used for PCI)

 Output(s) : error       - Function status

****************************************************************************/
Error  SBIIB_Init (CardHandle  *card,             /* Card handle           */
                   Ulong       cardAddress)       /* VME card address      */
/***************************************************************************/
{
Error  error;
#if(SBIIB_PCI_PLATFORM)
DWORD  dCntr;
#endif

    error = E_NO_ERROR;

    if(card == NO_POINTER)
        error = E_INVALID_POINTER;

return (error);
}

/****************************************************************************

 Function  : SBIIB_RdClock

 Purpose   : This function reads the SBIIB clock value.

 Input(s)  : card   - handle for the card
             time   - TimeTag structure for result

 Output(s) : error  - Function status

****************************************************************************/
Error  SBIIB_RdClock(CardHandle  *card,           /* Card handle           */
                     TimeTag     *time)           /* TimeTag structure     */
/***************************************************************************/
{
Error  error;
Ulong  clkH, clkL;
Uword  ckH, ckM, ckL, ckT;

    error = E_NO_ERROR;

    clkH = 0x80010000;
    clkL = 0x00000008;
    ckH  = (Uword)((clkH >> 16) & 0xFFFF);
    ckM  = (Uword)(clkH & 0xFFFF);
    ckL  = (Uword)((clkL >> 16) & 0xFFFF);
    ckT  = (Uword)(clkL & 0xFFFF);

    /*
     Now format the time value and save in the TimeTag structure.
    */
    if(error == E_NO_ERROR)
        error = SBIIB_FormatTtag(ckH, ckM, ckL, ckT, time);

return (error);
}

/****************************************************************************

 Function  : wW

 Purpose   : SBIIB primitive write word to card

 Input(s)  : card   - Handle for the card
             offset - Offset address in card
             value  - Value to write

 Output(s) : void

****************************************************************************/
void   wW(CardHandle  *card,                     /* Card handle            */
          Ulong       offset,                    /* Card address offset    */
          Uword       value)                     /* Value to write         */
/***************************************************************************/
{
    if(offset < 0x10000)
        dArray[offset/2] = value;        
}

/****************************************************************************

 Function  : rW

 Purpose   : SBIIB primitive read word from card

 Input(s)  : card   - Handle for the card
             offset - Offset address in card

 Output(s) : Uword  - Value at address in card.

****************************************************************************/
Uword  rW(CardHandle  *card,                     /* Card handle            */
          Ulong       offset)                    /* Card address offset    */
/***************************************************************************/
{
Ulong  adoffs;
Uword  value;

    if(offset >= 0x10000)
        value = 0xCAFE;
    else
        value = dArray[offset/2];

return (value);
}
